
/*******************************************************************************/
/*  
	This script produces Table A3
	Mongey, Pilossoph, and Weinberg: "Which Workers Bear the Burden of Social Distancing?"
	Journal of Economic Inequality 2021	
    --
	Alexander Weinberg
	February 16, 2021
*/
/*******************************************************************************/

// __________________________________________________
// Load Clean PSID Data
use "../Data/PSID/psid_occ_h2m", clear

// __________________________________________________
// SUMMARY STATS
eststo clear
eststo: qui estpost summarize ///
    age famwage labinc uhrswork1 networth college male own_home born_50states married ///
	 white fulltime old [aw=wgt], detail // format

esttab using "../Tables/tableA3.tex", cells("mean(fmt(2)) sd(fmt(2))") label nodepvar  ///
	varwidth(30) nonumbers booktabs title("PSID") ///
	replace nomtitles
	
// end
